# Network Intelligence

A unified social network analysis tool to leverage your professional and social networks.

## Quick Start

1. **Install dependencies:**
   ```bash
   npm install
   ```

2. **Add your data exports:**
   - Unzip your platform exports into the `data/` folder:
     - `data/linkedin/` - LinkedIn export (CSV files)
     - `data/facebook/` - Facebook export (JSON files)
     - `data/twitter/` - Twitter/X export
     - `data/instagram/` - Instagram export
     - `data/bluesky/` - Bluesky export
     - `data/threads/` - Threads export

3. **(Optional) Add Gemini API key:**
   ```bash
   cp .env.example .env
   # Edit .env and add your Gemini API key
   ```

4. **Run the app:**
   ```bash
   npm run dev
   ```

5. **Open in browser:**
   - Dashboard: http://localhost:5173
   - API: http://localhost:3001

## Features

- **AI-Powered Queries**: Ask natural language questions about your network
- **Relationship Scoring**: Half-life decay model for connection warmth
- **Warm Path Finder**: Find your route to any company or person
- **Action Alerts**: Know which connections need attention
- **Cross-Platform**: Merge contacts from all your social platforms

## Data Privacy

Your data stays completely local. Nothing is sent to external servers except optional Gemini AI queries.

## Data Export Links

- **LinkedIn**: https://www.linkedin.com/mypreferences/d/download-my-data
- **Facebook**: https://www.facebook.com/dyi
- **Twitter/X**: https://x.com/settings/download_your_data
- **Instagram**: https://accountscenter.instagram.com/info_and_permissions/dyi
- **Bluesky**: Settings → Export My Data
- **Threads**: Settings → Privacy → Download your information
